<?php

if (!class_exists('vB_Template'))
{
	// Ensure we have this
	require_once(DIR . '/dbtech/downloads/core/class_template.php');
}


class vB_ProfileBlock_DBTech_Downloads extends vB_ProfileBlock
{
	/**
	* The name of the template to be used for the block
	*
	* @var string
	*/
	var $template_name = 'dbtech_downloads_memberinfo_block_downloads';

	var $nowrap = true;

	var $skip_privacy_check = true;

	/**
	* Variables to automatically prepare
	*
	* @var array
	*/
	var $auto_prepare = array();

	/**
	* Sets/Fetches the default options for the block
	*
	*/
	function fetch_default_options()
	{
		$this->option_defaults = array(
			'pagenumber' => 1,
			'perpage'    => 25,
		);
	}

	/**
	* Whether to return an empty wrapper if there is no content in the blocks
	*
	* @return bool
	*/
	function confirm_empty_wrap()
	{
		return false;
	}

	/**
	* Whether or not the block is enabled
	*
	* @return bool
	*/
	function block_is_enabled($id)
	{
		return true;
	}

	/**
	* Prepare any data needed for the output
	*
	* @param	string	The id of the block
	* @param	array	Options specific to the block
	*/
	function prepare_output($id = '', $options = array())
	{
		global $vbphrase, $prepared;
		
		if (intval($this->registry->versionnumber) == 3)
		{
			$this->nowrap = false;
		}

		// Shorthands to faciliate easy copypaste
		$pagenumber = $options['pagenumber'];
		$perpage = $options['perpage'];

		$cacheResult = VBDOWNLOADS_CACHE::read('profile', 'profile.count.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult))
		{
			// Count number of users
			$count = VBDOWNLOADS::$db->fetchOne('
				SELECT COUNT(*)
				FROM $dbtech_downloads_download
				WHERE userid = ?
					AND moderation = 0
			', array($this->profile->userinfo['userid']));

			if ($cacheResult != -1)
			{
				// Write to the cache
				VBDOWNLOADS_CACHE::write(array('count' => $count), 'profile', 'profile.count.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$count = $cacheResult['count'];
		}

		if (!$count)
		{
			// We're done here
			return true;
		}

		// Ensure every result is as it should be
		sanitize_pageresults($count, $pagenumber, $perpage);
		
		// Find out where to start
		$startat = ($pagenumber - 1) * $perpage;

		$pageinfo = array(
			'tab' => $id
		);
		if ($perpage)
		{
			$pageinfo['pp'] = $perpage;
		}

		if (intval($this->registry->versionnumber) > 3)
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'',
				'',
				$id,
				'member',
				$this->profile->userinfo,
				$pageinfo
			);
		}
		else
		{
			$this->block_data['pagenav'] = construct_page_nav(
				$pagenumber,
				$perpage,
				$count,
				'member.php?' . $this->registry->session->vars['sessionurl'] . "u=" . $this->profile->userinfo['userid'] . "&amp;tab=$id" .
				(!empty($perpage) ? "&amp;pp=$perpage" : ""), '', $id
			);
		}

		$cacheResult = VBDOWNLOADS_CACHE::read('profile', 'profile.downloads.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
		if (!is_array($cacheResult))
		{
			// Fetch users
			$downloads = VBDOWNLOADS::$db->fetchAll('
				SELECT user.*, download.*
				FROM $dbtech_downloads_download AS download
				LEFT JOIN $user AS user USING(userid)
				WHERE download.userid = ?
					AND download.moderation = 0
				ORDER BY download.updated DESC
				LIMIT :limitStart, :limitEnd
			', array(
				$this->profile->userinfo['userid'],
				':limitStart' 	=> $startat,
				':limitEnd' 	=> $perpage
			));

			if ($cacheResult != -1)
			{
				// Write to the cache
				VBDOWNLOADS_CACHE::write($downloads, 'profile', 'profile.downloads.' . $startat . '.' . $perpage . '.' . $this->profile->userinfo['userid']);
			}
		}
		else
		{
			// Set the entry cache
			$downloads = $cacheResult;
		}
		
		require_once(DIR . '/includes/class_bbcode.php');
		$parser = new vB_BbCodeParser($this->registry, fetch_tag_list());

		$this->block_data['downloadsbits'] = '';
		foreach ($downloads as $download)
		{
			// No hacsors here please
			$download['title'] = htmlspecialchars_uni($download['title']);

			// Sort date and time
			$download['date'] = vbdate($this->registry->options['dateformat'], $download['updated'], true);
			$download['time'] = vbdate($this->registry->options['timeformat'], $download['updated']);

			if (strlen($download['description']) > $this->registry->options['dbtech_downloads_previewlength'])
			{
				// Shorten the description
				$download['description'] = substr($download['description'], 0, $this->registry->options['dbtech_downloads_previewlength']) . '...';
			}

			// Fix description
			$download['description'] = $parser->parse($download['description'], 'nonforum');
			
			$templater = vB_Template::create('dbtech_downloads_memberinfo_block_downloads_bits');
				$templater->register('download', $download);
			$this->block_data['downloadsbits'] .= $templater->render();
		}
		unset($parser);
		
		return $this->block_data;
	}
}
?>